/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.stackmap.MapMaker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.runtime.CompileVisitResult;
import team.unnamed.mocha.runtime.ExpressionInliner;
import team.unnamed.mocha.runtime.ExpressionInterpreter;
import team.unnamed.mocha.runtime.FunctionCompileState;
import team.unnamed.mocha.runtime.MochaFunction;
import team.unnamed.mocha.runtime.MolangCompilingVisitor;
import team.unnamed.mocha.runtime.Scope;
import team.unnamed.mocha.runtime.compiled.MochaCompiledFunction;
import team.unnamed.mocha.runtime.compiled.Named;
import team.unnamed.mocha.util.CaseInsensitiveStringHashMap;
import team.unnamed.mocha.util.JavassistUtil;

@ApiStatus.Internal
public final class MolangCompiler {
    private static final Random RANDOM = new Random();
    private final Object entity;
    private final ClassLoader classLoader;
    private final ClassPool classPool;
    private final Scope scope;
    private Consumer<byte @NotNull []> postCompile;

    public MolangCompiler(@Nullable Object entity, @NotNull ClassLoader classLoader, @NotNull Scope scope) {
        this.entity = entity;
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
        this.classPool = ClassPool.getDefault();
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    @Nullable
    public Object entity() {
        return this.entity;
    }

    @NotNull
    public ClassPool classPool() {
        return this.classPool;
    }

    public void postCompile(@Nullable Consumer<byte @NotNull []> postCompile) {
        this.postCompile = postCompile;
    }

    @NotNull
    public <T extends MochaCompiledFunction> T compile(@NotNull List<Expression> expressions, @NotNull Class<T> clazz) {
        Object t;
        Constructor constructor;
        Class compiledClass;
        StackMapTable stackMapTable;
        Objects.requireNonNull(expressions, "expressions");
        Objects.requireNonNull(clazz, "clazz");
        if (clazz == MochaFunction.class && expressions.isEmpty()) {
            return (T)((MochaCompiledFunction)clazz.cast(MochaFunction.nop()));
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Target type must be an interface: " + clazz.getName());
        }
        Executable implementedMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.isDefault()) continue;
            if (implementedMethod != null) {
                throw new IllegalArgumentException("Target type must have only one method: " + clazz.getName());
            }
            implementedMethod = method;
        }
        if (implementedMethod == null) {
            throw new IllegalArgumentException("Target type must have a method to implement: " + clazz.getName());
        }
        CaseInsensitiveStringHashMap<Integer> argumentParameterIndexes = new CaseInsensitiveStringHashMap<Integer>();
        Parameter[] parameters = implementedMethod.getParameters();
        CtClass[] ctParameters = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            Parameter parameter = parameters[i];
            Named named = parameter.getDeclaredAnnotation(Named.class);
            if (named != null) {
                name = named.value();
            } else if (parameter.isNamePresent()) {
                name = parameter.getName();
            } else {
                throw new IllegalArgumentException("Parameter " + parameter.getName() + " (index " + i + ") must be annotated with @Named and specify a name");
            }
            argumentParameterIndexes.put(name, Integer.valueOf(i));
            try {
                ctParameters[i] = this.classPool.get(parameter.getType().getName());
                continue;
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        CtClass interfaceCtClass = JavassistUtil.getClassUnchecked(this.classPool, clazz);
        String scriptClassName = this.getClass().getPackage().getName() + ".MolangFunctionImpl_" + clazz.getSimpleName() + "_" + ((Method)implementedMethod).getName() + "_" + Long.toHexString(System.currentTimeMillis()) + "_" + Integer.toHexString(RANDOM.nextInt(2024));
        CtClass scriptCtClass = this.classPool.makeClass(scriptClassName);
        scriptCtClass.addInterface(interfaceCtClass);
        scriptCtClass.setModifiers(1);
        Class<?> returnType = ((Method)implementedMethod).getReturnType();
        CtClass returnCtType = JavassistUtil.getClassUnchecked(this.classPool, returnType);
        Bytecode bytecode = new Bytecode(scriptCtClass.getClassFile().getConstPool());
        FunctionCompileState compileState = new FunctionCompileState(this, this.classPool, scriptCtClass, bytecode, (Method)implementedMethod, this.scope, argumentParameterIndexes);
        int maxLocals = 1;
        for (CtClass paramType : ctParameters) {
            if (paramType == CtClass.doubleType || paramType == CtClass.longType) {
                maxLocals += 2;
                continue;
            }
            ++maxLocals;
        }
        compileState.maxLocals(maxLocals);
        if (expressions.isEmpty()) {
            bytecode.addConstZero(returnCtType);
            bytecode.addReturn(returnCtType);
        } else {
            MolangCompilingVisitor compiler = new MolangCompilingVisitor(compileState);
            CompileVisitResult lastVisitResult = null;
            ExpressionInliner inliner = new ExpressionInliner(new ExpressionInterpreter<Object>(null, this.scope), this.scope);
            for (Expression expression : expressions) {
                lastVisitResult = expression.visit(inliner).visit(compiler);
            }
            if (lastVisitResult == null || !lastVisitResult.returned()) {
                if (lastVisitResult == null || lastVisitResult.lastPushedType() != returnCtType) {
                    JavassistUtil.addCast(bytecode, lastVisitResult == null ? CtClass.floatType : lastVisitResult.lastPushedType(), returnCtType);
                }
                compiler.endVisit();
            }
        }
        bytecode.setMaxLocals(compileState.maxLocals());
        MethodInfo method = new MethodInfo(scriptCtClass.getClassFile().getConstPool(), ((Method)implementedMethod).getName(), Descriptor.ofMethod((CtClass)returnCtType, (CtClass[])ctParameters));
        method.setAccessFlags(17);
        method.setCodeAttribute(bytecode.toCodeAttribute());
        try {
            method.getCodeAttribute().computeMaxStack();
            stackMapTable = MapMaker.make((ClassPool)this.classPool, (MethodInfo)method);
        }
        catch (BadBytecode e) {
            throw new IllegalStateException("Generated bad bytecode, open an issue at https://github.com/unnamed/mocha/issues", e);
        }
        if (stackMapTable != null) {
            method.getCodeAttribute().setAttribute(stackMapTable);
        }
        try {
            scriptCtClass.addMethod(CtMethod.make((MethodInfo)method, (CtClass)scriptCtClass));
        }
        catch (CannotCompileException e) {
            throw new IllegalStateException("Couldn't compile main function method", e);
        }
        Map<String, Object> requirements = compileState.requirements();
        for (Map.Entry<String, Object> entry : requirements.entrySet()) {
            String fieldName = entry.getKey();
            Object object = entry.getValue();
            CtClass fieldType = JavassistUtil.getClassUnchecked(this.classPool, object.getClass());
            try {
                scriptCtClass.addField(new CtField(fieldType, fieldName, scriptCtClass));
            }
            catch (CannotCompileException e) {
                throw new IllegalStateException("Couldn't compile field " + (String)fieldName + " with type " + fieldType.getName(), e);
            }
        }
        CtClass[] constructorParameterCtTypes = new CtClass[requirements.size()];
        int j = 0;
        for (Map.Entry entry : requirements.entrySet()) {
            constructorParameterCtTypes[j] = JavassistUtil.getClassUnchecked(this.classPool, entry.getValue().getClass());
            ++j;
        }
        CtConstructor ctConstructor = new CtConstructor(constructorParameterCtTypes, scriptCtClass);
        Bytecode bytecode2 = new Bytecode(scriptCtClass.getClassFile().getConstPool());
        bytecode2.addAload(0);
        bytecode2.addInvokespecial(JavassistUtil.getClassUnchecked(this.classPool, Object.class), "<init>", "()V");
        int parameterIndex = 0;
        for (Map.Entry<String, Object> entry : requirements.entrySet()) {
            String string = entry.getKey();
            Object fieldValue = entry.getValue();
            bytecode2.addAload(0);
            bytecode2.addAload(parameterIndex + 1);
            bytecode2.addPutfield(scriptCtClass, string, Descriptor.of((CtClass)JavassistUtil.getClassUnchecked(this.classPool, fieldValue.getClass())));
            ++parameterIndex;
        }
        bytecode2.addReturn(null);
        ctConstructor.getMethodInfo().setCodeAttribute(bytecode2.toCodeAttribute());
        try {
            ctConstructor.getMethodInfo().getCodeAttribute().computeMaxStack();
        }
        catch (BadBytecode e) {
            throw new IllegalStateException("Generated bad bytecode, open an issue at https://github.com/unnamed/mocha/issues", e);
        }
        ctConstructor.getMethodInfo().getCodeAttribute().setMaxLocals(constructorParameterCtTypes.length + 1);
        try {
            scriptCtClass.addConstructor(ctConstructor);
        }
        catch (CannotCompileException e) {
            throw new IllegalStateException("Couldn't compile script constructor", e);
        }
        if (this.postCompile != null) {
            try {
                this.postCompile.accept(scriptCtClass.toBytecode());
            }
            catch (IOException | CannotCompileException e) {
                throw new IllegalStateException("Couldn't collect script bytecode", e);
            }
        }
        try {
            compiledClass = this.classPool.toClass(scriptCtClass, this.getClass(), this.classLoader, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Couldn't compile script class", exception);
        }
        Class[] classArray = new Class[requirements.size()];
        Object[] constructorArguments = new Object[requirements.size()];
        int i = 0;
        for (Object object : requirements.values()) {
            classArray[i] = object.getClass();
            constructorArguments[i] = object;
            ++i;
        }
        try {
            constructor = compiledClass.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Couldn't find constructor with parameters " + String.valueOf(requirements.keySet()), noSuchMethodException);
        }
        try {
            t = constructor.newInstance(constructorArguments);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Couldn't instantiate script class", e);
        }
        return (T)((MochaCompiledFunction)clazz.cast(t));
    }
}

